<?php
namespace App\Http\Controllers\API;
use Illuminate\Http\Request;
use App;  

use Illuminate\Support\Facades\Auth; 
use Validator,Redirect,Response,File;
use DB;
use App\Http\Controllers\Controller as Controller;

class UserController extends Controller
{

		public function signup(Request $request){
			
			$validator = Validator::make($request->all(), [ 

		  'phone' => 'required|string|unique:volunteers|min:10|max:15',

          'email'=>'required|unique:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			
			$length = 50;
			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$charactersLength = strlen($characters);
			$randomString = '';
			for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
			}
			$randomString;
			
			$id = DB::table('volunteers')-> insertGetId(
			array(
					'name'=>$request->name,
					'phone'=>$request->phone,
					'email'=>$request->email,
					'password'=>$request->password,
					'location'=>$request->location,
					'token'=>$randomString,
					'address'=>$request->address
				));
				
				
			
			
            if($id){
				
			$userinfo = DB::table('volunteers')->where('id',$id)->get();
			$success['id'] =  $userinfo[0]->id;
			$success['name'] =  $userinfo[0]->name;
			$success['phone'] =  $userinfo[0]->phone;
			$success['email'] =  $userinfo[0]->email;
			$success['password'] =  $userinfo[0]->password;
			$success['location'] =  $userinfo[0]->location;
			$success['address'] =  $userinfo[0]->address;
			$success['token'] =  $userinfo[0]->token;

			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			
			}
			
		}
		
		}

		/*public function login(Request $request){
        
		$validator = Validator::make($request->all(), [ 
          'phone'=>'required|exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => 'Please use a registered phone number to login'
                ],
                200
            );
        }else{
			
			$length = 50;
			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$charactersLength = strlen($characters);
			$randomString = '';
			for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
			}
			$randomString;
	
			
			$rand = mt_rand(1500, 5000);
			$phone=$request->phone;
			
			$rand = mt_rand(1500, 5000);
			
			$userinfo = DB::table('volunteers')->where('phone',$phone)->get();
            $token = $userinfo[0]->token;
			if($token == ""){
				DB::table('volunteers')->where('phone',$phone)->update(
			array('otp'=>$rand,'token'=>$randomString));
			}else{
				DB::table('volunteers')->where('phone',$phone)->update(
			array('otp'=>$rand));
			}
			
            $userinfo = DB::table('volunteers')->where('phone',$phone)->get();
            $token = $userinfo[0]->token;
			
			
			$success['id'] =  $userinfo[0]->id;
			$success['name'] =  $userinfo[0]->name;
			$success['phone'] =  $userinfo[0]->phone;
			$success['otp'] =  $rand;
			$success['token'] =  $userinfo[0]->token;
			
			
				
			if($userinfo){
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			}
			
			
        }
        }*/
		
		public function login(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'email'=>'required|exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$email=$request->email;
			$password=$request->password;
			
			$exist = DB::table('volunteers')->where('email',$email)->where('password',$password)->exists();
			
			if($exist){
			  $userinfo = DB::table('volunteers')->where('email',$email)->get();
			$success['id'] =  $userinfo[0]->id;
			$success['name'] =  $userinfo[0]->name;
			$success['phone'] =  $userinfo[0]->phone;
			$success['email'] =  $userinfo[0]->email;
			$success['password'] =  $userinfo[0]->password;
			$success['location'] =  $userinfo[0]->location;
			$success['address'] =  $userinfo[0]->address;
			$success['token'] =  $userinfo[0]->token;

			 return response()->json(['success'=>$success,'response_code' => 200]); 
			 exit();
			}else{
			 return response()->json(['response_result'=>'Invalid Details','response_code' => 401]); 
			 exit();
			}
			
			
		  }
			
		}
		
		public function otp_verification(Request $request){
			
			
			 $validator = Validator::make($request->all(), [ 
          'otp'=>'required|exists:volunteers',
          'id'=>'required|exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$otp=$request->otp;
			$id=$request->id;
			
			$userinfo = DB::table('volunteers')
                ->where('otp',$otp)
                ->where('id',$id)
                ->exists();
				
				
			if($userinfo){
				
				$userinfo = DB::table('volunteers')
                ->where('otp',$otp)
                ->where('id',$id)
                ->get();
				
			$success['id'] =  $userinfo[0]->id;
			$success['name'] =  $userinfo[0]->name;
			$success['phone'] =  $userinfo[0]->phone;
			$success['otp'] =  $otp;
			$success['token'] =  $userinfo[0]->token;
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			}else{
			return response()->json(['success'=>'Invalid Details','response_code' => 200]); 
			exit();
			}	
			
		  }
		}
		
		public function schedule_meet(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
		$volunteer_id = $request->volunteer_id;
		$volunteer_id_doesnotexist = DB::table('volunteers')->where('id',$volunteer_id)->doesntExist();
		if($volunteer_id_doesnotexist){
		return response()->json(['response_result'=>'The selected volunteer_id is invalid','response_code' => 401]); 
		exit();
		}
			
		$id = DB::table('schedules')-> insertGetId(array(
		'volunteer_id' => $request->volunteer_id,
		'employ_name' => $request->employ_name,
		'title' => $request->title,
		'school_name' => $request->school_name,
		'date' => $request->date,
		'from_time' => $request->from_time,
		'to_time' => $request->to_time,
		'description' => $request->description,
		'attendence' => '0'
		));
		
		if($id){
			$result = DB::table('schedules')->where('id',$id)->get();
			
			$success['id'] =  $result[0]->id;
			$success['volunteer_id'] =  $result[0]->volunteer_id;
			$success['employ_name'] =  $result[0]->employ_name;
			$success['title'] =  $result[0]->title;
			$success['school_name'] =  $result[0]->school_name;
			$success['date'] =  $result[0]->date;
			$success['from_time'] =  $result[0]->from_time;
			$success['to_time'] =  $result[0]->to_time;
			$success['description'] =  $result[0]->description;
			$success['attendence'] =  $result[0]->attendence;
			
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			
		}else{
			return response()->json(['success'=>'Something went wrong','response_code' => 401]); 

		}
			
		 }
		
		}
		
		
		public function confirm_attendence(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'exists:schedules',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$id = $request->id;
			$result = DB::table('schedules')->where('id',$id)->get();
			$attendence = $result[0]->attendence;
			if($attendence=='1'){
				return response()->json(['response_result'=>'Meeting Already Attended','response_code' => 200]); 
			exit();
			}
			
		$update = DB::table('schedules')->where('id',$id)->update(
		array('attendence'=>'1'));
		if($update){
			
			$result = DB::table('schedules')->where('id',$id)->get();
			$success['attendence'] =  $result[0]->attendence;
			$success['id'] =  $result[0]->id;
			
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			
		}
			
		}
			
			
		}
		
		
		public function notification(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          //'id'=>'exists:schedules',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
		 $volunteer_id = $request->volunteer_id;
		 $notification = $request->notification;
		 $notification_title = $request->notification_title;
		 

		 
		 $result = DB::table('volunteers')->where('id',$volunteer_id)->exists();
		  if($result){
			 
		 	
		 
		 $id = DB::table('notification')-> insertGetId(array(
		'volunteer_id'=>$volunteer_id,
		 'notification'=>$notification,
		 'notification_title'=>$notification_title,
		 'view_status'=>'0'
		));
		
		$success = DB::table('notification')->where('id',$id)->get();
		 
		 
		 
		 return response()->json(['success'=>$success,'response_code' => 401]); 
			exit();
			 
		  }else{
			   return response()->json(['response_result'=>'Volunteer Id Is Invalid','response_code' => 401]); 
			exit();
		  }	
			
		}
			
			
		}
		
		public function notification_list(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'volunteer_id'=>'exists:notification',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
		 $volunteer_id = $request->volunteer_id;
		 
		 $result = DB::table('volunteers')->where('id',$volunteer_id)->exists();
		  if($result){
			 
		 $success = DB::table('notification')->where('volunteer_id',$volunteer_id)->get();
		 
		 return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			 
		  }else{
			   return response()->json(['response_result'=>'Volunteer Id Is Invalid','response_code' => 401]); 
			exit();
		  }	
			
		}
			
			
		}
		
		
		public function view_notification(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'exists:notification',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
		 $id = $request->id;
		 
		 DB::table('notification')->where('id',$id)->update(
		array('view_status'=>'1'));
		
		 $success = DB::table('notification')->where('id',$id)->get();
		 return response()->json(['success'=>$success,'response_code' => 200]); 
		 exit();
			
		}
			
			
		}
		
		public function schedule_meet_list(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'volunteer_id'=>'required|exists:schedules',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$id = $request->volunteer_id;
			$result = DB::table('schedules')->where('volunteer_id',$id)->orderBy('id','desc')->get();
			//$string = json.parse($result);
			return response()->json(['success'=>$result,'response_code' => 200]); 
			exit();
			
		}
			
		}
		
		public function schedule_meet_details(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'volunteer_id'=>'exists:schedules',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
		$meeting_id = $request->meeting_id;
		$meeting_id_doesnotexist = DB::table('notes')->where('meeting_id',$meeting_id)->doesntExist();
		if($meeting_id_doesnotexist){
		return response()->json(['response_result'=>'The selected meeting_id is invalid','response_code' => 401]); 
		exit();
		}
		
		
		$result = DB::table('notes')->where('meeting_id',$meeting_id)->orderBy('id','desc')->get();
		//$string = json.parse($result);
		return response()->json(['success'=>$result,'response_code' => 200]); 
		
		}
		
			
		}
		
		public function add_notes(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			
			$meeting_id = $request->meeting_id;
			$meeting_id_doesnotexist = DB::table('schedules')->where('id',$meeting_id)->doesntExist();
			if($meeting_id_doesnotexist){
			return response()->json(['response_result'=>'The selected meeting_id is invalid','response_code' => 401]); 
			exit();
			}
			
			$volunteer_id = $request->volunteer_id;
			$volunteer_id_doesnotexist = DB::table('volunteers')->where('id',$volunteer_id)->doesntExist();
			if($volunteer_id_doesnotexist){
			return response()->json(['response_result'=>'The selected volunteer_id is invalid','response_code' => 401]); 
			exit();
			}
			
			
			$id = DB::table('notes')-> insertGetId(array(
		'volunteer_id' => $request->volunteer_id,
		'meeting_id' => $request->meeting_id,
		'description' => $request->description
		));
		
		if($id){
			$result = DB::table('notes')->where('id',$id)->get();
			$success['id'] =  $result[0]->id;
			$success['volunteer_id'] =  $result[0]->volunteer_id;
			$success['meeting_id'] =  $result[0]->meeting_id;
			$success['description'] =  $result[0]->description;
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
		}else{
			return response()->json(['success'=>'Something went wrong','response_code' => 401]); 

		}
			
		}
		
		}
		
		
		public function notes_list(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'user_id'=>'required|exists:schedules',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$id = $request->user_id;
			$result = DB::table('notes')->where('volunteer_id',$id)->orderBy('id','desc')->get();
			//$string = json.parse($result);
			return response()->json(['success'=>$result,'response_code' => 200]); 
			exit();
			
		}
			
		}
		
		public function notes_delete(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'required|exists:notes',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$id = $request->id;
			$delete = DB::table('notes')->where('id',$id)->delete();
			
			if($delete){
			return response()->json(['response_status'=>'Data deleted successfully','response_code' => 200]); 

			}else{
				return response()->json(['response_status'=>'Something Went Wrong','response_code' => 401]);
			}
		}
			
		}
		
		public function notes_update(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'required|exists:notes',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$id = $request->id;
			$desc = $request->description;
			
			$update = DB::table('notes')->where('id',$id)->update(
		array('description'=>$desc));
			
			if($update){
           $result = DB::table('notes')->where('id',$id)->get();
			//$string = json.parse($result);
			return response()->json(['success'=>$result,'response_code' => 200]); 
			exit();
			}else{
				return response()->json(['response_status'=>'Something Went Wrong','response_code' => 401]);
			}
		}
			
		}
		
		
		public function volunteer_profile(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'required|exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$id = $request->id;
			$result = DB::table('volunteers')->where('id',$id)->get();
			$success['id'] =  $result[0]->id;
			$success['name'] =  $result[0]->name;
			$success['phone'] =  $result[0]->phone;
			$success['image'] =  $result[0]->image;
			
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			
		}
			
		}
		
		public function update_volunteer_profile_name(Request $request){
			
			$validator = Validator::make($request->all(), [ 
          'id'=>'required|exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			$id = $request->id;
			$name = $request->name;
			
			 $update = DB::table('volunteers')->where('id',$id)->update(
		array('name'=>$request->name));
		
		if($update){
			
			$result = DB::table('volunteers')->where('id',$id)->get();
			$success['id'] =  $result[0]->id;
			$success['name'] =  $result[0]->name;
			$success['phone'] =  $result[0]->phone;
			
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
		}
			
		}
			
		}
		
		public function update_volunteer_profile_image(Request $request)
		
		{
			$validator = Validator::make($request->all(), [ 
          'id'=>'required|exists:volunteers',
        ]);

         if ($validator->fails()){
            return response()->json(
                [
                    'response_code' => 401,
                    'response_result' => $validator->errors()->first()
                ],
                200
            );
        }else{
			
			if($request->file('file')){
		 $imageName = time().'.'.$request->file->extension();
		 $request->file->move(public_path('uploads/user'),$imageName);
		 $image=url('public/uploads/user').'/'.$imageName;
		 }
		 
		 
		    $id = $request->id;
			$update = DB::table('volunteers')->where('id',$id)->update(
		    array('image'=>$image));
		 
		   if($update){
			   
		    $result = DB::table('volunteers')->where('id',$id)->get();
			$success['id'] =  $result[0]->id;
			$success['name'] =  $result[0]->name;
			$success['phone'] =  $result[0]->phone;
			$success['image'] =  $result[0]->image;
			
			return response()->json(['success'=>$success,'response_code' => 200]); 
			exit();
			
		   }
			
		}
			
		}
		
		public function test_profile(Request $request)
		
		{
			
		 $id = DB::table('tests')-> insertGetId(array(
		 'name' => $request->name,
		 'phone' => $request->phone
		 ));
		
		if($id){
			return response()->json(['success'=>'Data inserted successfully','response_code' => 200]); 
			exit();
		}else{
			return response()->json(['success'=>'Something Went Wrong','response_code' => 200]); 
			exit();
		}
		}
		
		
		



}
