<?php

if (!function_exists('hasAccessTo')) {
    function hasAccessTo($permissionName) {
        if (Auth::user()->user_type_id == 1) { //For Admin
            return true;
        }

        $permissions = DB::table('permissions')
        ->join('permission_role', 'permissions.id', '=', 'permission_role.permission_id')
        ->where('permission_role.role_id',Auth::user()->role_id)
        ->pluck('permissions.name')->toArray();

        if (in_array($permissionName, $permissions)) {
            return true;
        }
        else{
            return false;
        }
    }
}

if (!function_exists('hasAccessToModule')) {
    function hasAccessToModule($moduleName) {
        if (Auth::user()->user_type_id == 1) {
            return true;
        }

        $permissions = DB::table('permissions')
        ->join('permission_role', 'permissions.id', '=', 'permission_role.permission_id')
        ->where('permission_role.role_id',Auth::user()->role_id)
        ->pluck('permissions.module')->toArray();

        if (in_array($moduleName, $permissions)) {
            return true;
        }
        else{
            return false;
        }
    }
}
