<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class BlockedPeriod extends Model
{
    protected $guarded = [];

    protected $appends = ['formatted_start_date', 'formatted_end_date'];

    public function getFormattedStartDateAttribute(): string
    {
        $formattedDate = Carbon::parse($this->start_date)->format('d-M-Y');

        return $formattedDate;
    }

    public function getFormattedEndDateAttribute(): string
    {
        $formattedDate = Carbon::parse($this->end_date)->format('d-M-Y');

        return $formattedDate;
    }
}
