<?php

namespace App\Http\Resources;

use App\Models\Appointment;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DashboardCalendarResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [];
        $appointments = Appointment::with('createdBy')->get();

        foreach ($appointments as $appointment) {
            $data[] = [
                'title' => $appointment->title,
                'start' => $appointment->appointment_date.' '.$appointment->appointment_start_time,
                'end' => $appointment->appointment_date.' '.$appointment->appointment_end_time,
                'color' => $appointment->createdBy->color_code
            ];
        }

        return $data;
    }
}
