<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';

    /**
     * Determine the current asset version.
     */
    public function version(Request $request): ?string
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @return array<string, mixed>
     */
    public function share(Request $request): array
    {
        if (!empty($request->user()) && $request->user()->user_type_id == 1) {
            App::setLocale('en');
        }
        elseif (!empty($request->user()) && $request->user()->user_type_id != 1) {
            App::setLocale('nl');
        } 
        else {
            App::setLocale('en');
        }

        if (!empty($request->user()) && $request->user()->profile_image !== null) {
            $profile_image = $request->user()->profile_image;
        } else {
            $profile_image = '/images/avatar1.png';
        }
        
        
        $file = lang_path( App::currentLocale() . ".json" );

        return [
            ...parent::share($request),
            'auth' => [
                'user' => $request->user(),
            ],
            'config' => [
                'organization' => config('app.show_organization'),
                'volunteer' => config('app.show_volunteer'),
                'professional' => config('app.show_professional')
            ],
            'profile_image' => $profile_image,
            'locale' => App::currentLocale(),
            'locales' => config( 'app.available_locales' ),
            'translations' => File::exists( $file ) ? File::json( $file ) : []
        ];
    }
}
