<?php

namespace App\Http\Controllers;

use App\Http\Resources\DashboardCalendarResource;
use App\Http\Resources\DashboardStatsResource;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class DashboardController extends Controller
{
    /**
     * Display the dashboard screen.
     */
    public function index(Request $request): Response
    {
        return Inertia::render('Dashboard', [
            'stats' => new DashboardStatsResource($request),
            'appointments' => new DashboardCalendarResource($request)
        ]);
    }
}
