<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('admin-login', [App\Http\Controllers\AdminController::class, 'index'])->name('admin-login');
Route::post('admin-login-post', [App\Http\Controllers\AdminController::class, 'login_post'])->name('admin-login-post');


Route::group(['middleware'=>['adminBasicAuth']],function(){

Route::get('admin-dashboard', [App\Http\Controllers\AdminController::class, 'admin_dashboard'])->name('admin-dashboard');
Route::get('professional', [App\Http\Controllers\AdminController::class, 'professional'])->name('professional');
Route::get('estimate', [App\Http\Controllers\AdminController::class, 'estimate'])->name('estimate');
Route::get('add-estimate', [App\Http\Controllers\AdminController::class, 'add_estimate'])->name('add-estimate');

/*---------- user management  ----------*/

Route::get('user', [App\Http\Controllers\AdminController::class, 'user_index'])->name('user');
Route::get('add-user', [App\Http\Controllers\AdminController::class, 'add_user'])->name('add-user');
Route::get('edit-user/{id}', [App\Http\Controllers\AdminController::class, 'edit_user'])->name('edit-user');
Route::post('update-user', [App\Http\Controllers\AdminController::class, 'update_user'])->name('update-user');
Route::get('delete-user/{id}', [App\Http\Controllers\AdminController::class, 'delete_user'])->name('delete-user');
Route::post('post-user', [App\Http\Controllers\AdminController::class, 'post_user'])->name('post-user');


/*---------- user management  ----------*/

/*---------- volunteer management  ----------*/

Route::get('volunteer', [App\Http\Controllers\AdminController::class, 'volunteer_index'])->name('volunteer');
Route::get('add-volunteer', [App\Http\Controllers\AdminController::class, 'add_volunteer'])->name('add-volunteer');
Route::get('edit-volunteer/{id}', [App\Http\Controllers\AdminController::class, 'edit_volunteer'])->name('edit-volunteer');
Route::post('update-volunteer', [App\Http\Controllers\AdminController::class, 'update_volunteer'])->name('update-volunteer');
Route::get('delete-volunteer/{id}', [App\Http\Controllers\AdminController::class, 'delete_volunteer'])->name('delete-volunteer');
Route::post('post-volunteer', [App\Http\Controllers\AdminController::class, 'post_volunteer'])->name('post-volunteer');


/*---------- volunteer management  ----------*/

/*---------- Export ----------*/
Route::get('articles/exportExcel', [App\Http\Controllers\AdminController::class, 'exportExcel'])->name('articles/exportExcel');
Route::get('articles/exportNotes', [App\Http\Controllers\AdminController::class, 'exportNotes'])->name('articles/exportNotes');
Route::get('articles/exportVolunteers', [App\Http\Controllers\AdminController::class, 'exportVolunteers'])->name('articles/exportVolunteers');

/*---------- Export ----------*/

/*---------- Schedule management ------------*/
Route::get('schedule', [App\Http\Controllers\AdminController::class, 'schedule_index'])->name('schedule');
Route::get('add-schedule', [App\Http\Controllers\AdminController::class, 'add_schedule'])->name('add-schedule');
Route::get('edit-schedule/{id}', [App\Http\Controllers\AdminController::class, 'edit_schedule'])->name('edit-schedule');
Route::post('update-schedule', [App\Http\Controllers\AdminController::class, 'update_schedule'])->name('update-schedule');
Route::get('delete-schedule/{id}', [App\Http\Controllers\AdminController::class, 'delete_schedule'])->name('delete-schedule');
Route::post('post-schedule', [App\Http\Controllers\AdminController::class, 'post_schedule'])->name('post-schedule');

/*---------- Schedule management ------------*/

/*---------- Assign Volunteer management ------------*/
Route::get('assign', [App\Http\Controllers\AdminController::class, 'assign_index'])->name('assign');
Route::get('assign-volunteer', [App\Http\Controllers\AdminController::class, 'assign_volunteer'])->name('assign-volunteer');
Route::get('edit-assign-volunteer/{id}', [App\Http\Controllers\AdminController::class, 'editassign_volunteer'])->name('edit-assign-volunteer');
Route::post('update-schedule', [App\Http\Controllers\AdminController::class, 'update_schedule'])->name('update-schedule');
Route::get('delete-assign-volunteer/{id}', [App\Http\Controllers\AdminController::class, 'deleteassign_volunteer'])->name('delete-assign-volunteer');
Route::post('postassign-volunteer', [App\Http\Controllers\AdminController::class, 'postassign_volunteer'])->name('postassign-volunteer');

/*---------- Assign Volunteer management ------------*/

/*---------- Notes ----------------*/
Route::get('notes', [App\Http\Controllers\AdminController::class, 'notes_index'])->name('notes');
Route::get('add-notes', [App\Http\Controllers\AdminController::class, 'add_notes'])->name('add-notes');
Route::post('post-notes', [App\Http\Controllers\AdminController::class, 'post_notes'])->name('post-notes');
Route::get('edit-notes/{id}', [App\Http\Controllers\AdminController::class, 'editnotes'])->name('edit-notes');
Route::post('update-notes', [App\Http\Controllers\AdminController::class, 'updatenotes'])->name('update-notes');
Route::get('delete-notes/{id}', [App\Http\Controllers\AdminController::class, 'deletenotes'])->name('delete-notes');
/*---------- Notes ----------------*/

});

Route::get('logout', [App\Http\Controllers\AdminController::class, 'logout'])->name('logout');

